/*
 * 學習如何使用可變電組調整 LED 的亮度，透過數位接腳模擬 PWM 輸出。
 */
 
int vrPin = 0;    // 定義可變電阻(VR: Variable Resistor)輸入的接腳
int ledPin = 9;   // 定義 PWM 輸出 LED 的按腳
                  // UNO R3 可使用的 PWM 接腳： 3,5,6,9,10,11
int vrVal = 0;    // 儲存可變電阻傳入的值

void setup()
{
  pinMode(ledPin, OUTPUT);   // 定義 LED 接腳為输出
}

void loop()
{
  vrVal = analogRead(vrPin);    // 讀取可變電阻傳回的值 (0~1023)
  analogWrite(ledPin, vrVal/4); // 輸出 LED 亮度值 (0~255)
  delay(10);                    // 延遲 0.01 秒
}

