/*
 * 示範光遮開關模組(Light Locking Sensor)的應用
 * 當放置阻礙物(如卡片)於模組中央時，表示光遮會輸出數位訊號 1 開啟 LED，
 * 當無阻礙時會輸出數位訊號 0 開閉 LED。
 */

// 使用 LCD1602 I2C 顯示器顯示結果
// 定義 LCD 元件(位置 0x27 及 16x2 的顯示)
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27,16,2); 

// 定義全域變數值
byte sensorPin = 7;               // 定義感測器的接收腳位
byte ledPin = 13;                 // 定義 LED 的腳位
byte sensorValue = 0;             // 儲存感測器的值

// 程式初化設定
void setup () 
{
  lcd.begin();                    // 開啟 LCD 元件
  lcd.backlight();                // 開啟 LCD 背光
  pinMode (ledPin, OUTPUT);       // 設定 LED 為輸出模式
  pinMode (sensorPin, INPUT);     // 設定感測器為輸入模式
}
 
// 主程式迴圈
void loop () 
{
  sensorValue = digitalRead(sensorPin);       // 讀取光遮感測器的值
  displayValue(sensorValue, 0);               // 將感應器值顯示於 LCD
  digitalWrite (ledPin, sensorValue);         // 依值開啟或關閉 LED
}

// 顯示偵測觸發的值
void displayValue(int value, byte row) {
  lcd.setCursor(0, row);                      // 設定游標位置
  lcd.print("Value: ");
  lcd.print(value);                           // 顯示偵測資料的值
  lcd.print("    ");                          // 清除行尾文字
}
