/*
 * 示範敲擊開關(Tap Switch)的應用，使用敲擊方式切換開關的狀態。
 */

// 使用 LCD1602 I2C 顯示器顯示結果
// 定義 LCD 元件(位置 0x27 及 16x2 的顯示)
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27,16,2); 

// 定義全域變數值
const byte sensorPin = 7;         // 定義感測器的接收腳位
const byte ledPin = 13;           // 定義 LED 的腳位
byte sensorValue = 0;             // 儲存感測器的值
int tapCounter = 0;               // 敲擊累計次數
int tapState = 0;                 // 敲擊狀態
int LastTapState = 0;             // 前次敲擊狀態
  
// 程式初化設定
void setup () 
{
  lcd.begin();                    // 開啟 LCD 元件
  lcd.backlight();                // 開啟 LCD 背光
  pinMode (sensorPin, INPUT);     // 設定感測器為輸入模式
  pinMode (ledPin, OUTPUT);       // 設定 LED 為輸出模式
}
 
// 主程式迴圈
void loop () 
{
  tapState = digitalRead(sensorPin);      // 讀取感應器的值
  if (tapState != LastTapState) {         // 若有偵測到敲擊時累計敲擊次數
    if (tapState == HIGH) {               // 若敲擊狀態 = HIGH 表示有 Tap
      tapCounter++;                       // 累計敲擊次數
      if (tapCounter % 4 == 0) {          // 每累計 4 次表示開啟
        digitalWrite(ledPin, HIGH);       // 開啟 LED 
        displayValue("LED = ", HIGH, 0);  // 將 LED 狀態顯示於 LCD
      } else {
        digitalWrite(ledPin, LOW);        // 關閉 LED 
        displayValue("LED = ", LOW, 0);   // 將 LED 狀態顯示於 LCD
      }
    } 
  }
  LastTapState = tapState;                // 儲存上次狀態
  
}

// 顯示偵測觸發的值
void displayValue(String str, int value, byte row) {
  lcd.setCursor(0, row);                  // 設定游標位置
  lcd.print(str);                         // 顯示值的標題
  lcd.print(value);                       // 顯示資料的值
  lcd.print("    ");                      // 清除行尾資料
}
