/*
 * 示範溫度感測模組 (DS18B20) 的應用
 * 利用模組接收環境溫度，將溫度值顯示於 LCD1602 上。
 */

#include <LiquidCrystal_I2C.h>          // 引用 LCD1602_I2C 程式庫
#include <OneWire.h>                  // 引用 OneWire 程式庫
#include <DallasTemperature.h>        // 引用 DallasTemperature 程式庫

#define ONE_WIRE_BUS 2                // 定義 DS18B20 資料腳位(數位腳 D2)
LiquidCrystal_I2C lcd(0x27,16,2);      // 定義 LCD 元件(位置 0x27 及 16x2 的顯示)
OneWire oneWire(ONE_WIRE_BUS);        // 定義 oneWire 物件類型
DallasTemperature sensors(&oneWire);  // 定義溫度感測器物件

// 程式初化設定
void setup(void)
{
  lcd.begin();                       // 開啟 LCD 元件
  lcd.backlight();                   // 開啟 LCD 背光
}

// 主程式迴圈
void loop(void)
{ 
  sensors.requestTemperatures();            // 下指令要求取得溫度感測器的溫度值
  lcd.setCursor(0, 0);                      // 設定游標位置
  lcd.print("Temp: ");
  lcd.print(sensors.getTempCByIndex(0));    // 顯示溫度值
  lcd.print("    ");
}
