/*
 * 示範溫濕度偵測模組(DHT 11, Temperature & Humidity Moudle)的應用
 * 讀取溫濕度值 DHT.read11(sensorPin)
 * 溫度值： DHT.temperature
 * 濕度值： DHT.humidity
 */

#include <dht.h>                   // 載入溫濕度程式庫
dht DHT;                           // 定義元件名稱

// 使用 LCD1602 I2C 顯示器顯示結果
// 定義 LCD 元件(位置 0x27 及 16x2 的顯示)
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27,16,2); 

// 定義全域變數值
byte sensorPin = 7;               // 定義感測器的接收腳位
byte ledPin = 13;                 // 定義 LED 的腳位
byte sensorValue = 0;             // 儲存感測器的值
  
// 程式初化設定
void setup () 
{
  lcd.begin();                    // 開啟 LCD 元件
  lcd.backlight();                // 開啟 LCD 背光
  pinMode (sensorPin, INPUT);     // 設定感測器為輸入模式
}
 
// 主程式迴圈
void loop () 
{
  int chk = DHT.read11(sensorPin);                           // 讀取環境的溫濕度值
  displayValue("Temperature = ",DHT.temperature, 0);         // 將溫度值顯示於 LCD
  displayValue("Humidity = ",DHT.humidity, 1);               // 將濕度值顯示於 LCD
  delay(1000);                                               // 暫停 1 秒
}

// 顯示偵測觸發的值
void displayValue(String str, int value, byte row) {
  lcd.setCursor(0, row);                        // 設定游標位置
  lcd.print(str);                               // 顯示值的標題
  lcd.print(value);                             // 顯示資料的值
  lcd.print("    ");                            // 清除行尾資料
}
