/*
 * KY018 Photo Resistor Module，示範光感電阻模組LDR(Light Dependend Resistor)的應用：
 * 光電組是一種可變電組，電組值是依據光線的強弱而不同，當光線變暗時可用於開啟燈光，
 * 電阻值  80 Ohm  ~ 20M Ohm，傳回的值 0(光亮)~ 255(光暗)。
 */

// 使用 LCD1602 I2C 顯示器顯示結果
// 定義 LCD 元件(位置 0x27 及 16x2 的顯示)
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27,16,2); 

// 定義全域變數值
byte sensorPin = A0;              // 定義感測器的接收腳位
byte sensorValue = 0;            // 儲存感測器的值

// 程式初化設定
void setup () 
{
  lcd.begin();                    // 開啟 LCD 元件
  lcd.backlight();                // 開啟 LCD 背光
  pinMode (sensorPin, INPUT);     // 設定感測器為輸入模式
}
 
// 主程式迴圈
void loop () 
{
  sensorValue = analogRead(sensorPin);          // 讀取感測器的值
  displayValue(sensorValue, 0);                 // 將感應器值顯示於 LCD
  delay(200);                                   // 暫停 200 ms
}

// 顯示偵測觸發的值
void displayValue(int value, byte row) {
  lcd.setCursor(0, row);                        // 設定游標位置
  lcd.print("Value: ");
  lcd.print(value);                             // 顯示偵測資料的值
  lcd.print("    ");
}
