/*
 * 示範水銀傾斜開關模組(Mercury Tilt Switch)的應用
 * 當傾斜時訊會輸出數位訊號 1 開啟 LED，
 * 當不傾斜時訊會輸出數位訊號 0 開閉 LED。
 */

// 使用 LCD1602 I2C 顯示器顯示結果
// 定義 LCD 元件(位置 0x27 及 16x2 的顯示)
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27,16,2); 

// 定義全域變數值
byte sensorPinDO = 7;             // 定義感測器的接收腳位
byte ledPin = 13;                 // 定義 LED 的腳位
byte sensorValueDO = 0;           // 儲存感測器的值

// 程式初化設定
void setup () 
{
  lcd.begin();                    // 開啟 LCD 元件
  lcd.backlight();                // 開啟 LCD 背光
  pinMode (ledPin, OUTPUT);       // 設定 LED 為輸出模式
  pinMode (sensorPinDO, INPUT);   // 設定感測器為輸入模式
}
 
// 主程式迴圈
void loop () 
{
  sensorValueDO = digitalRead(sensorPinDO);     // 讀取感測器的值
  digitalWrite (ledPin, sensorValueDO);         // 依值開啟或關閉 LED
  displayValue(sensorValueDO, 0);               // 將感應器值顯示於 LCD
}

// 顯示偵測觸發的值
void displayValue(int value, byte row) {
  lcd.setCursor(0, row);                        // 設定游標位置
  lcd.print("Value: ");
  lcd.print(value);                             // 顯示偵測資料的值
  lcd.print("    ");
}
