/* 魔術光杯(KY-027)的應用
 * 使用一組兩個光杯，放置於一個平台上，當平台向左傾斜時左邊的光杯燈亮，
 * 反之右光杯燈亮。
 */
 
byte LedPinA = 2;              // 定義光杯 A Led 腳位
byte SignalPinA = 3;           // 定義光杯 A 訊號來源腳位
byte LedPinB = 4;              // 定義光杯 B Led 腳位
byte SignalPinB = 5;           // 定義光杯 B 訊號來源腳位
byte SignalStatusA = 0;        // 定義光杯 A 訊號來源的值
byte SignalStatusB = 0;        // 定義光杯 B 訊號來源的值

void setup()
{
  pinMode(LedPinA, OUTPUT);    // 設定光杯 A Led 腳位為輸出模式
  pinMode(LedPinB, OUTPUT);    // 設定光杯 B Led 腳位為輸出模式
  pinMode(SignalPinA, INPUT);  // 設定光杯 A 訊號來源腳位為輸入模式
  pinMode(SignalPinB, INPUT);  // 設定光杯 B 訊號來源腳位為輸入模式
}
void loop()
{
  // 讀取光杯 A/B 訊號來源的值
  SignalStatusA = digitalRead(SignalPinA);
  SignalStatusB = digitalRead(SignalPinB);

  // 開啟或關閉光杯 A/B
  digitalWrite(LedPinA, SignalStatusA);
  digitalWrite(LedPinB, SignalStatusB);
  
  // 持續一段時間的開關
  delay(25);   
}
