/* 魔術光杯(KY-027)的應用
 * 魔術光杯的應用：使用一組兩個光杯，讓光杯 A 傾斜開啟時累加一個值、
 * 光杯 B 傾斜開啟時遞減一個值，當數值 <  128 時光杯 A 為關閉 B為開啟，
 * 數值 >= 128 時光杯A 為開啟B為關閉，且組合只有在其中一個開另一個關時
 * 才會作用，即兩者同時開或關時，值是不會改變的。
 */
 
byte LedPinA = 2;              // 定義光杯 A Led 腳位
byte SignalPinA = 3;           // 定義光杯 A 訊號來源腳位
byte LedPinB = 4;              // 定義光杯 B Led 腳位
byte SignalPinB = 5;           // 定義光杯 B 訊號來源腳位
byte SignalStatusA = 0;        // 定義光杯 A 訊號來源的值
byte SignalStatusB = 0;        // 定義光杯 B 訊號來源的值
byte brightness = 0;           // 定義開關的值以決定那個光杯開啟或關閉

void setup()
{
  pinMode(LedPinA, OUTPUT);    // 設定光杯 A Led 腳位為輸出模式
  pinMode(LedPinB, OUTPUT);    // 設定光杯 B Led 腳位為輸出模式
  pinMode(SignalPinA, INPUT);  // 設定光杯 A 訊號來源腳位為輸入模式
  pinMode(SignalPinB, INPUT);  // 設定光杯 B 訊號來源腳位為輸入模式
}
void loop()
{
  // 讀取光杯 A 訊號來源的值
  SignalStatusA = digitalRead(SignalPinA);
  // 若開啟累加 brightness 的值
  if(SignalStatusA == HIGH) brightness ++;

  // 讀取光杯 B 訊號來源的值
  SignalStatusB = digitalRead(SignalPinB);
  // 若開遞減 brightness 的值
  if(SignalStatusB == HIGH) brightness --;

  // 開啟或關閉光杯 A/B
  analogWrite(LedPinA, brightness);
  analogWrite(LedPinB, 255 - brightness);
  
  // 持續一段時間的開關
  delay(25);   
}
