/*
 * 示範旋轉編碼器(Relary Encoder)的應用
 * 順時針異動加 1 ，逆時針異動減 1。
 */

// 使用 LCD1602 I2C 顯示器顯示結果
// 定義 LCD 元件(位置 0x27 及 16x2 的顯示)
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27,16,2); 

// 定義全域變數值
#define CLK_Pin 5                 // CLK pin of Rotary Enocoder
#define DT_Pin 6                  // DT pin of Rotary Enocoder
 
int counter = 1;                  // 累計值
int presentState;                 // 目前的狀態
int previousState;                // 上次的狀態
int presentVal;                   // 目前的狀態值
int previousVal;                  // 上次的狀態值
 
void setup() { 
  lcd.begin();                    // 開啟 LCD 元件
  lcd.backlight();                // 開啟 LCD 背光
  pinMode (CLK_Pin,INPUT);        // 設定 CLK Pin 為輸入模式
  pinMode (DT_Pin,INPUT);         // 設定 DT Pin 為輸入模式
} 

void loop() { 
  presentState = digitalRead(CLK_Pin);           // 讀取 CLK 的值
  if (presentState != previousState) {           // 若 CLK 的值有異動
    
    // 讀取 DT 的值, 順時針異動加 1 ，逆時針異動減 1
    if (digitalRead(DT_Pin) != presentState){     
      counter --;
    } else {
      counter ++;
    }
    
    // 轉動一次會發出兩次異動，兩次才輸出結果一次
    if ( counter % 2 == 0 ) {             
      presentVal = (int)(counter / 2);           // 兩次取一次結果
      if (presentVal != previousVal) {
        displayValue(presentVal,0);              // 將結果顯示於 LCD
        previousVal = presentVal;                // 保存上次的值
      }
    }
  } 
  previousState = presentState;                  // 保存上次的狀態
}

// 顯示偵測觸發的值
void displayValue(int value, byte row) {
  lcd.setCursor(0, row);                        // 設定游標位置
  lcd.print("Value: ");
  lcd.print(value);                             // 顯示偵測資料的值
  lcd.print("    ");
}
