/*
 * 示範震動開關模組(Shock Sensor)的應用
 * 感應器可以偵測震動，不確定時回傳  0，若偵測到震動時回傳1。
 * 當震動時訊會輸出數位訊號 1 開啟 LED，
 * 當沒有震動時訊會輸出數位訊號 0 開閉 LED。
 */

// 使用 LCD1602 I2C 顯示器顯示結果
// 定義 LCD 元件(位置 0x27 及 16x2 的顯示)
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27,16,2); 

// 定義全域變數值
const byte sensitivity = 20;      // 設定敏感度，當超過此值表示有震動
byte sensorPinDO = 7;             // 定義感測器的接收腳位
byte ledPin = 13;                 // 定義 LED 的腳位
byte sensorValueDO = 0;           // 儲存感測器的值
byte shockCnt = 0;                // 累積震動次數

// 程式初化設定
void setup () 
{
  lcd.begin();                    // 開啟 LCD 元件
  lcd.backlight();                // 開啟 LCD 背光
  pinMode (ledPin, OUTPUT);       // 設定 LED 為輸出模式
  pinMode (sensorPinDO, INPUT);   // 設定感測器為輸入模式
}
 
// 主程式迴圈
void loop () 
{
  sensorValueDO = digitalRead(sensorPinDO);  // 讀取聲音感測器的 DO 值
  if (sensorValueDO == HIGH) {               // 若有震動傳入，進入震動介斷
    while (sensorValueDO == HIGH) {          // 當有震動訊號時，持續判斷
      shockCnt++;                            // 累計震動次數
      if (shockCnt > sensitivity) {          // 當超過敏感度時表示震動
        displayValue(HIGH, 0);               // 震動時顯示 1 於 LCD
        digitalWrite (ledPin, HIGH);         // 震動時開啟 LED
      }
      sensorValueDO = digitalRead(sensorPinDO); // 讀取下一個震動值
    }
  } else {
    displayValue(LOW, 0);              // 沒有震動時顯示 0 於 LCD
    digitalWrite (ledPin, LOW);        // 沒有震動時關閉 LED
    shockCnt = 0;                      // 重設震動計數器為 0，重新計算 
  }
  delay(100);                          // 暫停 100 ms
}

// 顯示偵測觸發的值
void displayValue(int value, byte row) {
  lcd.setCursor(0, row);                        // 設定游標位置
  lcd.print("Value: ");
  lcd.print(value);                             // 顯示偵測資料的值
  lcd.print("    ");
}
