/* 金屬觸控模組(KY-036) 
 * 當金屬或手指等導體按觸時，會感應到並傳送出訊號(DO Pin 腳及 AO Pin 腳)，
 * 此特性可用來當作觸控開關，並可調整模組上的電組旋鈕來調整觸控距離的敏感度。
 * DO 腳位：為感測器數位的輸出腳位，其值接觸為 1(HIGH)，未接觸為 0 (LOW)。
 * AO 腳位：為感測器類比的輸出腳位，其值範圍0 ~1023，
 *          接觸時其值 < 512 ，未接觸時其值 > 512
 * 以下範例為使用 AO 的值來開啟或關閉 LED 。
 */

int LedPin = 13;                 // 定義 Led 腳位
int AO_Pin = A5;                 // 定義觸控開關類比輸出(Analog Output)腳位
int AO_Val = 0;                  // 儲存觸控開關感測類比輸出(Analog Output)的值
long low_count = 0;

void setup()
{
  pinMode(LedPin, OUTPUT);       // 設定 Led 腳位為輸出模式
  Serial.begin(9600);             // 開啟序列輸出
}

void loop()
{
  AO_Val = analogRead(AO_Pin);            // 讀取 AO 腳位的值
  // 當手接觸時重設 low_count 值為 0
  // 否則累計達 10 次以上表示持續未接觸
  if (AO_Val < 512) low_count = 0;
  else low_count ++;
  if (AO_Val > 512 && low_count > 10) {
    digitalWrite(LedPin, LOW);            // 持續未接觸時關閉 LED
    Serial.println(LOW);                   // 輸出 LOW 的結果
  }
  else {
    digitalWrite(LedPin, HIGH);           // 有接觸時開啟 LED
    Serial.println(HIGH);                  // 輸出 HIGH 的結果
  }
  delay(25);                              // LED 燈持續開啟或關閉
}
