/*
 * 示範火焰感測模組 (Flame Module) 的應用
 * 利用帶焰感測模組接收環境的火焰(如使用打火機測試)，
 * 當感測到火焰時(如點燃打火機)時 LED 亮起。
 */

// 使用 LCD1602 I2C 顯示器顯示結果
// 定義 LCD 元件(位置 0x27 及 16x2 的顯示)
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27,16,2); 

// 定義全域變數值
const byte ON = HIGH;             // 定義 ON 的值為 HIGH
const byte OFF = LOW;             // 定義 OFF 的值為 LOW
byte sensorPinAO = A0;            // 定義感測器的接收腳位
byte sensorPinDO = 7;             // 定義感測器的接收腳位
byte ledPin = 13;                 // 定義 LED 的腳位
byte sensorValueAO = 0;           // 儲存感測器的值
byte sensorValueDO = 0;           // 儲存感測器的值
byte triggerValue = 128;          // 設定超過此觸發值時亮起 LED

// 程式初化設定
void setup () 
{
  lcd.begin();                    // 開啟 LCD 元件
  lcd.backlight();                // 開啟 LCD 背光
  pinMode (sensorPinAO, INPUT);   // 設定感測器為輸入模式
  pinMode (sensorPinDO, INPUT);   // 設定感測器為輸入模式
  pinMode (ledPin, OUTPUT);       // 設定 LED 為輸出模式
}
 
// 主程式迴圈
void loop () 
{
  sensorValueAO = analogRead(sensorPinAO);      // 讀取聲音感測器的 AO 值
  displayValue(sensorValueAO, 1);               // 將感應器 AO 值顯示於 LCD
  sensorValueDO = digitalRead(sensorPinDO);     // 讀取聲音感測器的 DO 值
  displayValue(sensorValueDO, 0);               // 將感應器 DO 值顯示於 LCD

  if (sensorValueAO > triggerValue) {           // 當 AO 超過觸發值開啟 LED
    digitalWrite(ledPin, ON);                   // 開啟 LED
  } else {
    digitalWrite(ledPin, OFF);                  // 關閉 LED
  }
  delay(500);                                   // 暫停 500 ms
}

// 顯示偵測觸發的值
void displayValue(int value, byte row) {
  lcd.setCursor(0, row);                        // 設定游標位置
  lcd.print("Value: ");
  lcd.print(value);                             // 顯示偵測資料的值
  lcd.print("    ");
}
