/*
 * 這個感測器使用紅外線(IR)的發射與接收來偵測前方是否有障礙物，
 * 偵測的距離約為 7CM，當障礙物位於偵測範圍內時 OUT=0、在範圍外時OUT=1，
 * 可應用於機器人或搖控車。。
 */

// 使用 LCD1602 I2C 顯示器顯示結果
// 定義 LCD 元件(位置 0x27 及 16x2 的顯示)
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27,16,2); 
byte ledPin = 13;                 // 定義 LED 接腳
byte inPin = 3;                   // 定義感測器的接收腳位
byte val=0;                       // 取得感測器的值

// 程式初化設定
void setup () 
{
  lcd.begin();                    // 開啟 LCD 元件
  lcd.backlight();                // 開啟 LCD 背光
  pinMode(ledPin, OUTPUT);        // 設定 LED 為輸出模式
  pinMode(inPin, INPUT) ;         // 設定感測器的接收腳位為輸入模式
}
 
// 主程式迴圈
void loop () 
{
  val = digitalRead(inPin);       // 讀取聲音感測器的值
  if (val == HIGH) {
    digitalWrite(ledPin, LOW);    // 障礙物在範圍外 LED=OFF
    displayValue(LOW);            // 將結果顯示於 LCD 範圍外 Value=0
  } else {
    digitalWrite(ledPin, HIGH);   // 障礙物在範圍外 LED=ON
    displayValue(HIGH);           // 將結果顯示於 LCD 範圍外 Value=1
  }
  delay(500);                     // 暫停 500 ms
}

// 顯示偵測觸發的值
void displayValue(byte value) {
  lcd.setCursor(0, 1);            // 設定游標位置
  lcd.print("Value: ");
  lcd.print(value);               // 顯示偵測資料的值
  lcd.print("    ");
}
