/*
 * 示範麥克風模組 (Microphone Module) 的應用
 * 利用麥克風模組接收環境聲音，當音量超過設定值時，
 * 藉由 5V 的繼電器開關電燈。
 */

// 使用 LCD1602 I2C 顯示器顯示結果
// 定義 LCD 元件(位置 0x27 及 16x2 的顯示)
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27,16,2); 
const byte ON = HIGH;             // 定義 ON 的值為 HIGH
const byte OFF = LOW;             // 定義 OFF 的值為 LOW
byte relayPin = 3;                // 定義繼電器接腳
byte sensorA0Pin = A0;            // 定義聲音感測器的接收腳位
byte sensorA0Value = 0;           // 儲存聲音感測器的值
byte triggerValue = 50;           // 設定觸發值
byte lightStatus = OFF;           // 儲存燈開啟的狀態

// 程式初化設定
void setup () 
{
  lcd.begin();                    // 開啟 LCD 元件
  lcd.backlight();                // 開啟 LCD 背光
  pinMode (relayPin, OUTPUT);     // 設定 LED 為輸出模式
  detectTriggerValue();           // 設定觸發值為週圍環境 +10 的音量
}
 
// 主程式迴圈
void loop () 
{
  sensorA0Value = analogRead(sensorA0Pin);      // 讀取聲音感測器的值
  if (sensorA0Value > triggerValue) {           // 當音量超過觸發值開關電燈
    displayValue(sensorA0Value);                  // 顯示音感測器的值
    if (lightStatus == ON) {                    // 依電燈開關的狀態切換
      digitalWrite (relayPin, LOW);             // 關閉電燈
      lightStatus = OFF;                        // 設定電燈狀態為關
    } else {
      digitalWrite (relayPin, HIGH);            // 開啟電燈
      lightStatus = ON;                         // 設定電燈狀態為關
    }
    delay(1000);                                // 暫停一秒
  }
}

// 偵測週遭的環境，+10 設為觸發開關的值
int detectTriggerValue() {
  int detectTime = millis();                   // 儲存偵測的時間
  int detectValue = 0;                         // 儲存偵測的音量值
  int maxValue = 0;                            // 儲存音量的最大值

  // 偵測三秒鐘取最大值為週遭的值
  while (detectTime < 3000) {
    detectValue = analogRead (sensorA0Pin);    // 讀取音量值
    if (detectValue > maxValue) {             
      maxValue = detectValue;                  // 設定音量的最大值
    }
    detectTime = millis();                     // 儲存偵測的時間
  }
  triggerValue = maxValue + 10;                // +10 設為觸發開關的值
  displayTriggerValue();                       // 顯示觸發的值於 LCD
}

// 顯示要觸發開關的值
void displayTriggerValue() {
  lcd.setCursor(0, 0);                         // 設定游標位置
  lcd.print("Trigger: ");
  lcd.print(triggerValue);                     // 顯示觸發開關的值
  lcd.print("    ");
}

// 顯示偵測觸發的值
void displayValue(int value) {
  lcd.setCursor(0, 1);                         // 設定游標位置
  lcd.print("Value: ");
  lcd.print(value);                            // 顯示偵測資料的值
  lcd.print("    ");
}
