/*
 * 示範搖桿的操作，將 X, Y, Z 軸的值顯示出來
 */

// 使用 LCD1602 I2C 顯示器顯示結果
#include <LiquidCrystal_I2C.h>
// 定義 LCD 元件(位置 0x27 及 16x2 的顯示)
LiquidCrystal_I2C lcd(0x27,16,2);  

// 定義搖桿的接腳及資料儲存變數
const int xPin = 0;             // 類比接腳連接於 X 軸。
const int yPin = 1;             // 類比接腳連接於 Y 軸。
const int swPin = 2;            // SW 數位接腳連接於 Z 軸按鈕。
unsigned int xValue;            // 儲存 X 軸的值。
unsigned int yValue;            // 儲存 Y 軸的值。
unsigned int zValue;            // 儲存 Z 軸的值。

// 程式初化設定
void setup() {
  lcd.begin();                  // 開啟 LCD 元件
  lcd.backlight();              // 開啟 LCD 背光
  pinMode(swPin, INPUT);        // 設定按鈕腳位為輸入模式
  digitalWrite(swPin, HIGH);    // 必須將按鈕腳位電位拉昇
}

// 主程式迴圈 
void loop() {
  getJoyStickValue();           // 讀取搖桿的值
  displayResult();              // 顯示讀取資料的值
}

// 讀取搖桿的值
void getJoyStickValue() {
  xValue = analogRead(xPin);    // 讀取 X 軸的值
  yValue = analogRead(yPin);    // 讀取 Y 軸的值
  zValue = digitalRead(swPin);  // 讀取 Z 軸的值
}

// 顯示讀取資料的值
void displayResult() {
  // 顯示 X 值
  lcd.setCursor(0,0);
  lcd.print("X:");
  lcd.print(xValue);
  lcd.print("   ");
  // 顯示 Y 值
  lcd.setCursor(8,0);
  lcd.print("Y:");
  lcd.print(yValue);
  lcd.print("   ");
  // 顯示 Z 值
  lcd.setCursor(0,1);
  lcd.print("Z:");
  lcd.print(zValue);
}
