// 本程式採用共陽極七段顯示器
// 定義七段顯示器的 dp, a, b,  c, d, e, f, g 腳位
int digital7LED[8] = {11, 10, 9, 8, 7, 6, 5, 4};
int digitalNum[12] = {  // bit 的順序： Bgfedc.ba
  B10000001,    // '0'
  B11110011,    // '1'
  B01001001,    // '2'
  B01100001,    // '3'
  B00110011,    // '4'
  B00100101,    // '5'
  B00000101,    // '6'
  B11110001,    // '7'
  B00000001,    // '8'
  B00100001,    // '9'
  B00000000,    // 'S' - 全亮
  B11111111     // 'C. - 清除(全暗)
};

// 設置變數
int i = 0;              // 迴圈變數
char ch = '0';          // 取得來自 UART 的數字
bool dpOn = false;      // 小數點預設關閉
 
void setup()
{
  Serial.begin(9600);   // 開啟 UART
  for (i = 0; i < 8; i++) {
    pinMode(digital7LED[i], OUTPUT);
  }
  displayNumber(11);;  // 初始值為關閉所有 LED
}
 
void loop()
{
  if (Serial.available()) {
    ch = Serial.read();
    if (ch <= '9' && ch >= '0')
      displayNumber(ch - '0');
    else if (ch == 'S' || ch == 's')  // 設 LED 全亮
      displayNumber(10);
    else if (ch == 'C' || ch == 'c')  // 設 LED 全暗
      displayNumber(11);
    else if (ch == '.') // Set dot point ON / OFF
      if (dpOn) setDpOn(false); 
      else setDpOn(true);
  }
}

void displayNumber(int Num){
  // 設定腳位 a ~ g 的值
  for (i = 1; i < 8; i++) {
    digitalWrite(digital7LED[i], bitRead(digitalNum[Num],i));
  }
  // 設定腳位 dp 的值
  if (Num == 10) setDpOn(true);   // 開啟小數點
  if (Num == 11) setDpOn(false);  // 關閉小數點
}

void setDpOn(bool setOn) {
  // digital7LED[0] 為 dp PIN 腳
  dpOn = setOn;
  if (dpOn)
    digitalWrite(digital7LED[0], LOW);   
  else
    digitalWrite(digital7LED[0], HIGH);   
}

