unsigned char btnPin = 2;       // 按鈕開關連接至 btnPin
unsigned char ledPin = 9;       // M5 LED 連接至 ledPin
volatile boolean btnVal = 0;    // 按鈕的狀態

void btnDetected() {            // 當按鈕狀態有變化時時產生中斷
  btnVal = digitalRead(btnPin); // 取得按鈕的狀態值
}

void setup() {
  pinMode(btnPin, INPUT);       // 按鈕腳位設為輸入模式
  pinMode(ledPin, OUTPUT);      // LED 腳位設為輸出模式

  // 當按鈕狀態有變化時時產生中斷
  // 0：: 以 ATMega328 為例，中斷 0 為 D2、中斷 1 為 D3
  // btnDetected：中斷發生時執行的程序
  // 中斷類型為值有變更時(CHANGE)
  attachInterrupt(0, btnDetected, CHANGE); 
}

void loop() {
  if(btnVal)      // 按鈕按下時點亮 LED
    digitalWrite(ledPin, HIGH);    
  else            // 按鈕放開時關閉 LED
    digitalWrite(ledPin, LOW);           
}
